
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get all service keys (service ids plus optional build numbers) belong to one host from
 * a global host key value store. By clicking each serviceId and buildNumber combination on
 * the UI, one can see the details of the registered service.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/getService/0.1.0")
public class GetService implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetService.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        if(StringUtils.isBlank(apiId)) apiId = null;
        String apiName = (String)map.get("apiName");
        if(StringUtils.isBlank(apiName)) apiName = null;
        String apiDesc = (String)map.get("apiDesc");
        if(StringUtils.isBlank(apiDesc)) apiDesc = null;
        String operationOwner = (String)map.get("operationOwner");
        if(StringUtils.isBlank(operationOwner)) operationOwner = null;
        String deliveryOwner = (String)map.get("deliveryOwner");
        if(StringUtils.isBlank(deliveryOwner)) deliveryOwner = null;
        String region = (String)map.get("region");
        if(StringUtils.isBlank(region)) region = null;
        String businessGroup = (String)map.get("businessGroup");
        if(StringUtils.isBlank(businessGroup)) businessGroup = null;
        String lob = (String)map.get("lob");
        if(StringUtils.isBlank(lob)) lob = null;
        String platform = (String)map.get("platform");
        if(StringUtils.isBlank(platform)) platform = null;
        String capability = (String)map.get("capability");
        if(StringUtils.isBlank(capability)) capability = null;
        String gitRepo = (String)map.get("gitRepo");
        if(StringUtils.isBlank(gitRepo)) gitRepo = null;
        String apiTags = (String)map.get("apiTags");
        if(StringUtils.isBlank(apiTags)) apiTags = null;
        String apiStatus = (String)map.get("apiStatus");
        if(StringUtils.isBlank(apiStatus)) apiStatus = null;
        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} apiId = {} apiName = {} apiDesc = {} operationOwner = {} deliveryOwner = {} region = {} businessGroup = {} lob = {} platform = {} capability = {} gitRepo = {} apiTags = {} apiStatus = {}", offset, limit, hostId, apiId, apiName, apiDesc, operationOwner, deliveryOwner, region, businessGroup, lob, platform, capability, gitRepo, apiTags, apiStatus);
        Result<String> result = dbProvider.queryService(offset, limit, hostId, apiId, apiName,
                apiDesc, operationOwner, deliveryOwner, region, businessGroup, lob, platform, capability, gitRepo,
                apiTags, apiStatus);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "api_t", hostId));
        } else {
            String services = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("services = {}", services);
            return NioUtils.toByteBuffer(services);
        }

    }
}
