
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get endpoint scope by hostId, apiId, apiVersion and endpoint. It is used by the portal-view to render the endpoint scope
 * page from the service endpoint page. The endpoint scope page will display the scopes associated with the endpoint.
*/
@ServiceHandler(id="lightapi.net/service/getEndpointScope/0.1.0")
public class GetEndpointScope implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointScope.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String endpointId = (String)map.get("endpointId");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {} endpointId = {}", hostId, endpointId);
        Result<String> result = dbProvider.queryEndpointScope(hostId, endpointId);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "endpoint scope", "hostId: " + hostId + " endpointId: " + endpointId));
        } else {
            String endpointScope = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("endpointScope = {}", endpointScope);
            return NioUtils.toByteBuffer(endpointScope);
        }
    }
}
