
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get endpoint rule by hostId, apiId, apiVersion and endpoint. It is used by the portal-view to render the endpoint rule
 * page from the service endpoint page. The endpoint rule page will display the rules associated with the endpoint.
*/
@ServiceHandler(id="lightapi.net/service/getEndpointRule/0.1.0")
public class GetEndpointRule implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointRule.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        String endpoint = (String)map.get("endpoint");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {} apiId = {} apiVersion = {} endpoint = {}", hostId, apiId, apiVersion, endpoint);
        Result<String> result = dbProvider.queryEndpointRule(hostId, apiId, apiVersion, endpoint);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "endpoint rule", "hostId: " + hostId + " apiId: " + apiId + " apiVersion: " + apiVersion + " endpoint: " + endpoint));
        } else {
            String endpointRule = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("endpointRule = {}", endpointRule);
            return NioUtils.toByteBuffer(endpointRule);
        }
    }
}
