
package net.lightapi.portal.service.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get endpoint label for dropdown
*/
@ServiceHandler(id="lightapi.net/service/getEndpointLabel/0.1.0")
public class GetEndpointLabel implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetEndpointLabel.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {} apiId {} apiVersion {}", hostId, apiId, apiVersion);
        Result<String> result = dbProvider.queryEndpointLabel(hostId, apiId, apiVersion);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "endpoint", String.format("hostId %s apiId %s apiVersion %s", hostId, apiId, apiVersion)));
        } else {
            String endpointLabels = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("endpointLabels = {}", endpointLabels);
            return NioUtils.toByteBuffer(endpointLabels);
        }
    }
}
