/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.service.command.handler;

import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.PortalUtil;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/service/createServiceVersion/0.1.0")
public class CreateServiceVersion
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateServiceVersion.class);
    private static final String INVALID_CONTENT_FORMAT = "ERR11641";
    private static final String INVALID_REMOTE_URL = "ERR11642";

    protected String getCloudEventType() {
        return "ServiceVersionCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String spec = (String)map.get("spec");
        if (spec == null || spec.isBlank()) {
            String specLink = (String)map.remove("specLink");
            if (specLink == null || specLink.isBlank()) return Success.of(map);
            if (!(specLink = specLink.trim()).endsWith(".yml") && !specLink.endsWith(".yaml")) return Failure.of((Status)new Status(INVALID_CONTENT_FORMAT, new Object[]{"YAML"}));
            try {
                spec = PortalUtil.readUrl((String)specLink);
                if (!PortalUtil.isValidYaml((String)spec)) {
                    return Failure.of((Status)new Status(INVALID_CONTENT_FORMAT, new Object[]{"YAML"}));
                }
                map.put("spec", spec);
                return Success.of(map);
            }
            catch (Exception e) {
                return Failure.of((Status)new Status(INVALID_REMOTE_URL, new Object[]{specLink}));
            }
        } else {
            if (PortalUtil.isValidYaml((String)spec)) return Success.of(map);
            return Failure.of((Status)new Status(INVALID_CONTENT_FORMAT, new Object[]{"YAML"}));
        }
    }
}

