
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This handler will update the specification associated with a service on the light-portal. If you want to delete a
 * specification, just submit a request with an empty spec.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/updateServiceSpec/0.1.0")
public class UpdateServiceSpec extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateServiceSpec.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SERVICE_SPEC_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
