
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * update a service from the service admin page.
*/
@ServiceHandler(id="lightapi.net/service/updateService/0.1.0")
public class UpdateService extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateService.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SERVICE_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
