
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * delete a service from the service page
*/
@ServiceHandler(id="lightapi.net/service/deleteService/0.1.0")
public class DeleteService extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteService.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SERVICE_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
