
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Delete an endpoint rule for a service. It is used from the portal-view to delete a rule from a service endpoint.
*/
@ServiceHandler(id="lightapi.net/service/deleteEndpointRule/0.1.0")
public class DeleteEndpointRule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteEndpointRule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ENDPOINT_RULE_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
