
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is the endpoint to publish a brand-new API regardless the style. An optional specification for the API will be uploaded
 * here so that all the endpoints will be extracted from it. If that is the case, it will be parsed and extra all the endpoints
 * and a list of endpoints will be associated with the service.
 *
 * For each API, there will be a unique id. The serviceId that is human friendly like com.networknt.petstore-1.0.0. Another id is
 * unique guaranteed and normally there is an application to trace the id allocation. The format can be api0001 etc. For users,
 * you can choose one format vs another for the serviceId during the service registration.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/service/createService/0.1.0")
public class CreateService extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateService.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SERVICE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
