
package net.lightapi.portal.service.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Create a new endpoint rule for a service. It is used from the portal-view to add a new rule to a service endpoint.
*/
@ServiceHandler(id="lightapi.net/service/createEndpointRule/0.1.0")
public class CreateEndpointRule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateEndpointRule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ENDPOINT_RULE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
