
package net.lightapi.portal.schema.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * transform the input to cloud event and push it into Kafka topic to delete a schema.
*/
@ServiceHandler(id="lightapi.net/schema/deleteSchema/0.1.0")
public class DeleteSchema extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteSchema.class);
    @Override
    protected String getCloudEventType() {
        return PortalConstants.SCHEMA_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_SCHEMA;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the schemeId in the data section.
        return (String) map.get("schemeId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
