
package net.lightapi.portal.schedule.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * update a schedule for an event
*/
@ServiceHandler(id="lightapi.net/schedule/updateSchedule/0.1.0")
public class UpdateSchedule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSchedule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SCHEDULE_UPDATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_SCHEDULE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the scheduleId in the data section.
        return (String) map.get("scheduleId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

}
