
package net.lightapi.portal.schedule.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.Util;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a new schedule for an event
*/
@ServiceHandler(id="lightapi.net/schedule/createSchedule/0.1.0")
public class CreateSchedule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateSchedule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.SCHEDULE_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_SCHEDULE;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the scheduleId in the data section.
        return (String) map.get("scheduleId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("scheduleId", UuidUtil.getUUID());
        return Success.of(map);
    }
}
