/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/rule/getRuleById/0.1.0")
public class GetRuleById
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleById.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        String ruleId = (String)map.get("ruleId");
        if (logger.isTraceEnabled()) {
            logger.trace("ruleId = {}", (Object)ruleId);
        }
        if ((result = dbProvider.queryRuleById(ruleId)).isSuccess()) {
            Map ruleMap = (Map)result.getResult();
            String json = JsonMapper.toJson((Object)ruleMap);
            if (logger.isTraceEnabled()) {
                logger.trace("json = {}", (Object)json);
            }
            return NioUtils.toByteBuffer((String)json);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("rule with ruleId {} not found", (Object)ruleId);
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"rule with ruleId ", ruleId}));
    }
}

