
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is the endpoint that is used by a service to load during the startup to execute a group of rules
 * at the same time. Most of the case, it is for the validation rules so that a list of validation rules
 * will be executed together and each will validate one business rule.
 *
 * The return object is a list of maps.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/getRuleByGroup/0.1.0")
public class GetRuleByGroup implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleByType.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String host = (String)map.get("host");
        String groupId = (String)map.get("groupId");
        if(logger.isTraceEnabled()) logger.trace("host = {} groupId = {}", host, groupId);
        Result<List<Map<String, Object>>> result = dbProvider.queryRuleByHostGroup(host, groupId);
        if(result.isSuccess()) {
            List<Map<String, Object>> ruleList = result.getResult();
            String json = JsonMapper.toJson(ruleList);
            if(logger.isTraceEnabled()) logger.trace("json = {}", json);
            return NioUtils.toByteBuffer(json);
        } else {
            if(logger.isTraceEnabled()) logger.trace("rule with host {} group {} not found", host, groupId);
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "rule with group ", groupId));
        }
    }
}
