
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Get a list of rules that are associated with an API by API id. This endpoint is used by the API to load the rules
 * for the API during the server startup.
 *
 * The return object is a list of maps.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/getRuleByApiId/0.1.0")
public class GetRuleByApiId implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleByApiId.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        if(logger.isTraceEnabled()) logger.trace("hostId = {} apiId = {} apiVersion {}", hostId, apiId, apiVersion);
        Result<List<Map<String, Object>>> result = dbProvider.queryRuleByHostApiId(hostId, apiId, apiVersion);
        if(result.isSuccess()) {
            List<Map<String, Object>> ruleList = result.getResult();
            String json = JsonMapper.toJson(ruleList);
            if(logger.isTraceEnabled()) logger.trace("json = {}", json);
            return NioUtils.toByteBuffer(json);
        } else {
            String s = String.format( "rule with hostId %s apiId %s and apiVersion %s not found", hostId, apiId, apiVersion);
            if(logger.isTraceEnabled()) logger.trace(s);
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, s));
        }
    }
}
