/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import net.lightapi.portal.rule.query.handler.GetRuleByType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/rule/getRuleByGroup/0.1.0")
public class GetRuleByGroup
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleByType.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String host = (String)map.get("host");
        String groupId = (String)map.get("groupId");
        if (logger.isTraceEnabled()) {
            logger.trace("host = {} groupId = {}", (Object)host, (Object)groupId);
        }
        if ((result = dbProvider.queryRuleByHostGroup(host, groupId)).isSuccess()) {
            List ruleList = (List)result.getResult();
            String json = JsonMapper.toJson((Object)ruleList);
            if (logger.isTraceEnabled()) {
                logger.trace("json = {}", (Object)json);
            }
            return NioUtils.toByteBuffer((String)json);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("rule with host {} group {} not found", (Object)host, (Object)groupId);
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"rule with group ", groupId}));
    }
}

