/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/rule/getRuleByApiId/0.1.0")
public class GetRuleByApiId
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleByApiId.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        String apiId = (String)map.get("apiId");
        String apiVersion = (String)map.get("apiVersion");
        if (logger.isTraceEnabled()) {
            logger.trace("hostId = {} apiId = {} apiVersion {}", new Object[]{hostId, apiId, apiVersion});
        }
        if ((result = dbProvider.queryRuleByHostApiId(hostId, apiId, apiVersion)).isSuccess()) {
            List ruleList = (List)result.getResult();
            String json = JsonMapper.toJson((Object)ruleList);
            if (logger.isTraceEnabled()) {
                logger.trace("json = {}", (Object)json);
            }
            return NioUtils.toByteBuffer((String)json);
        }
        String s = String.format("rule with hostId %s apiId %s and apiVersion %s not found", hostId, apiId, apiVersion);
        if (logger.isTraceEnabled()) {
            logger.trace(s);
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{s}));
    }
}

