/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.rule.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/rule/getRule/0.1.0")
public class GetRule
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRule.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String common;
        String ruleOwner;
        String ruleBody;
        String ruleDesc;
        String ruleGroup;
        String ruleType;
        String ruleVersion;
        String ruleName;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String ruleId = (String)map.get("ruleId");
        if (StringUtils.isEmpty((CharSequence)ruleId)) {
            ruleId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleName = (String)map.get("ruleName")))) {
            ruleName = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleVersion = (String)map.get("ruleVersion")))) {
            ruleVersion = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleType = (String)map.get("ruleType")))) {
            ruleType = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleGroup = (String)map.get("ruleGroup")))) {
            ruleGroup = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleDesc = (String)map.get("ruleDesc")))) {
            ruleDesc = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleBody = (String)map.get("ruleBody")))) {
            ruleBody = null;
        }
        if (StringUtils.isEmpty((CharSequence)(ruleOwner = (String)map.get("ruleOwner")))) {
            ruleOwner = null;
        }
        if (StringUtils.isEmpty((CharSequence)(common = (String)map.get("common")))) {
            common = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} ruleId = {} ruleName = {} ruleVersion = {} ruleType = {} ruleGroup = {} ruleDesc = {} ruleBody = {} ruleOwner = {} common = {}", new Object[]{offset, limit, hostId, ruleId, ruleName, ruleVersion, ruleType, ruleGroup, ruleDesc, ruleBody, ruleOwner, common});
        }
        if ((result = dbProvider.queryRule(offset, limit, hostId, ruleId, ruleName, ruleVersion, ruleType, ruleGroup, ruleDesc, ruleBody, ruleOwner, common)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"rule_t", hostId}));
        }
        String rules = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("rules = {}", (Object)rules);
        }
        return NioUtils.toByteBuffer((String)rules);
    }
}

