
package net.lightapi.portal.rule.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a list of rules for a host by rule type. The light-portal uses this endpoint to populate the list of rules
 * for the endpoint access and filter rules. As the result is used by the react-schema-form-rc-select, it needs to
 * be a list of key/value pairs for the dropdowns.
 *
 * This API return all the rules for the host by the rule type and also the common rules with the same rule type.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/getRuleByType/0.1.0")
public class GetRuleByType implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleByType.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        String ruleType = (String)map.get("ruleType");
        if(logger.isTraceEnabled()) logger.trace("hostId = {} ruleType = {}", hostId, ruleType);
        Result<String> result = dbProvider.queryRuleByHostType(hostId, ruleType);
        if(result.isSuccess()) {
            String rules = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("rules = {}", rules);
            return NioUtils.toByteBuffer(rules);
        } else {
            if(logger.isTraceEnabled()) logger.trace("rule with hostId {} ruleType {} not found", hostId, ruleType);
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "rule with hostId|ruleType ", hostId + "|" +  ruleType));
        }
    }
}
