
package net.lightapi.portal.rule.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a rule by its ruleId that is uniquely identified a rule. A map with all the rule properties will
 * be returned by this endpoint. If the rule is not found, an error will be returned.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/getRuleById/0.1.0")
public class GetRuleById implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRuleById.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        String ruleId = (String)map.get("ruleId");
        if(logger.isTraceEnabled()) logger.trace("ruleId = {}", ruleId);
        Result<Map<String, Object>> result = dbProvider.queryRuleById(ruleId);
        if(result.isSuccess()) {
            Map<String, Object> ruleMap = result.getResult();
            String json = JsonMapper.toJson(ruleMap);
            if(logger.isTraceEnabled()) logger.trace("json = {}", json);
            return NioUtils.toByteBuffer(json);
        } else {
            if(logger.isTraceEnabled()) logger.trace("rule with ruleId {} not found", ruleId);
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "rule with ruleId ", ruleId));
        }
    }
}
