
package net.lightapi.portal.rule.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a list of rules for a host or common with other filters. The returned result is paginated.
 * The portal-view will use this endpoint to displace all rules that is associated with the host.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/getRule/0.1.0")
public class GetRule implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRule.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String ruleId = (String)map.get("ruleId");
        if(StringUtils.isEmpty(ruleId)) ruleId = null;
        String ruleName = (String)map.get("ruleName");
        if(StringUtils.isEmpty(ruleName)) ruleName = null;
        String ruleVersion = (String)map.get("ruleVersion");
        if(StringUtils.isEmpty(ruleVersion)) ruleVersion = null;
        String ruleType = (String)map.get("ruleType");
        if(StringUtils.isEmpty(ruleType)) ruleType = null;
        String ruleGroup = (String)map.get("ruleGroup");
        if(StringUtils.isEmpty(ruleGroup)) ruleGroup = null;
        String ruleDesc = (String)map.get("ruleDesc");
        if(StringUtils.isEmpty(ruleDesc)) ruleDesc = null;
        String ruleBody = (String)map.get("ruleBody");
        if(StringUtils.isEmpty(ruleBody)) ruleBody = null;
        String ruleOwner = (String)map.get("ruleOwner");
        if(StringUtils.isEmpty(ruleOwner)) ruleOwner = null;
        String common = (String)map.get("common");
        if(StringUtils.isEmpty(common)) common = null;

        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} ruleId = {} ruleName = {} ruleVersion = {} ruleType = {} ruleGroup = {} ruleDesc = {} ruleBody = {} ruleOwner = {} common = {}",
                    offset, limit, hostId, ruleId, ruleName, ruleVersion, ruleType, ruleGroup, ruleDesc, ruleBody, ruleOwner, common);
        Result<String> result = dbProvider.queryRule(offset, limit, hostId, ruleId, ruleName, ruleVersion, ruleType, ruleGroup, ruleDesc, ruleBody, ruleOwner, common);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "rule_t", hostId));
        } else {
            String rules = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("rules = {}", rules);
            return NioUtils.toByteBuffer(rules);
        }
    }
}
