/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.rule.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.status.Status;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/rule/createRule/0.1.0")
public class CreateRule
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRule.class);

    protected String getCloudEventType() {
        return "RuleCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String hostId = (String)map.get("hostId");
        Result resultDomain = HybridQueryClient.getHostDomainById((HttpServerExchange)exchange, (String)hostId);
        if (resultDomain.isFailure()) {
            return Failure.of((Status)resultDomain.getError());
        }
        String domain = (String)resultDomain.getResult();
        Object ruleId = (String)map.get("ruleId");
        ruleId = (String)ruleId + "." + domain;
        map.put("ruleId", ruleId);
        map.put("ruleBody", JsonMapper.toJson(map));
        return Success.of(map);
    }
}

