
package net.lightapi.portal.rule.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Update rule with the host and ruleId.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/updateRule/0.1.0")
public class UpdateRule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UpdateRule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.RULE_UPDATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("ruleBody", JsonMapper.toJson(map));
        return Success.of(map);
    }

}
