
package net.lightapi.portal.rule.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Delete an existing rule with host and ruleId
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/deleteRule/0.1.0")
public class DeleteRule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.RULE_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
