
package net.lightapi.portal.rule.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * Create a rule for a particular host with the content in YAML.
 *
 * @author Steve Hu
*/
@ServiceHandler(id="lightapi.net/rule/createRule/0.1.0")
public class CreateRule extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRule.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.RULE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String hostId = (String)map.get("hostId");
        Result<String> resultDomain = HybridQueryClient.getHostDomainById(exchange, hostId);
        if(resultDomain.isFailure()) {
            return Failure.of(resultDomain.getError());
        }

        String domain = resultDomain.getResult();
        String ruleId = (String)map.get("ruleId");
        ruleId = ruleId + "." + domain;
        map.put("ruleId", ruleId);
        map.put("ruleBody", JsonMapper.toJson(map));
        return Success.of(map);
    }
}
