/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/role/queryRoleUser/0.1.0")
public class QueryRoleUser
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryRoleUser.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String userType;
        String lastName;
        String firstName;
        String email;
        String entityId;
        String userId;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String roleId = (String)map.get("roleId");
        if (StringUtils.isEmpty((CharSequence)roleId)) {
            roleId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(userId = (String)map.get("userId")))) {
            userId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(entityId = (String)map.get("entityId")))) {
            entityId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(email = (String)map.get("email")))) {
            email = null;
        }
        if (StringUtils.isEmpty((CharSequence)(firstName = (String)map.get("firstName")))) {
            firstName = null;
        }
        if (StringUtils.isEmpty((CharSequence)(lastName = (String)map.get("lastName")))) {
            lastName = null;
        }
        if (StringUtils.isEmpty((CharSequence)(userType = (String)map.get("userType")))) {
            userType = null;
        }
        if ((result = dbProvider.queryRoleUser(offset, limit, hostId, roleId, userId, entityId, email, firstName, lastName, userType)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"role user", hostId}));
        }
        String roleUsers = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("roleUsers = {}", (Object)roleUsers);
        }
        return NioUtils.toByteBuffer((String)roleUsers);
    }
}

