/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/role/getRole/0.1.0")
public class GetRole
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRole.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String roleDesc;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map map = (Map)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String roleId = (String)map.get("roleId");
        if (StringUtils.isEmpty((CharSequence)roleId)) {
            roleId = null;
        }
        if (StringUtils.isEmpty((CharSequence)(roleDesc = (String)map.get("roleDesc")))) {
            roleDesc = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} roleId = {} roleDesc = {}", new Object[]{offset, limit, hostId, roleId, roleDesc});
        }
        if ((result = dbProvider.queryRole(offset, limit, hostId, roleId, roleDesc)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"role", hostId}));
        }
        String roles = (String)result.getResult();
        if (logger.isTraceEnabled()) {
            logger.trace("roles = {}", (Object)roles);
        }
        return NioUtils.toByteBuffer((String)roles);
    }
}

