
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * return the relationship between group and user.
*/
@ServiceHandler(id="lightapi.net/role/queryRoleUser/0.1.0")
public class QueryRoleUser implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(QueryRoleUser.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String roleId = (String)map.get("roleId");
        if(StringUtils.isEmpty(roleId)) roleId = null;
        String userId = (String)map.get("userId");
        if(StringUtils.isEmpty(userId)) userId = null;
        String entityId = (String)map.get("entityId");
        if(StringUtils.isEmpty(entityId)) entityId = null;
        String email = (String)map.get("email");
        if(StringUtils.isEmpty(email)) email = null;
        String firstName = (String)map.get("firstName");
        if(StringUtils.isEmpty(firstName)) firstName = null;
        String lastName = (String)map.get("lastName");
        if(StringUtils.isEmpty(lastName)) lastName = null;
        String userType = (String)map.get("userType");
        if(StringUtils.isEmpty(userType)) userType = null;

        Result<String> result = dbProvider.queryRoleUser(offset, limit, hostId, roleId, userId, entityId, email, firstName, lastName, userType);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "role user", hostId));
        } else {
            String roleUsers = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("roleUsers = {}", roleUsers);
            return NioUtils.toByteBuffer(roleUsers);
        }
    }
}
