
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Query role row filter
*/
@ServiceHandler(id="lightapi.net/role/queryRoleRowFilter/0.1.0")
public class QueryRoleRowFilter implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(
            QueryRoleRowFilter.class
    );
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider =
            (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if (logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>) input;
        int offset = (Integer) map.get("offset");
        int limit = (Integer) map.get("limit");
        String hostId = (String) map.get("hostId");
        String roleId = (String) map.get("roleId");
        if (StringUtils.isEmpty(roleId)) roleId = null;
        String apiId = (String) map.get("apiId");
        if (StringUtils.isEmpty(apiId)) apiId = null;
        String apiVersion = (String) map.get("apiVersion");
        if (StringUtils.isEmpty(apiVersion)) apiVersion = null;
        String endpoint = (String) map.get("endpoint");
        if (StringUtils.isEmpty(endpoint)) endpoint = null;

        Result<String> result = dbProvider.queryRoleRowFilter(
                offset,
                limit,
                hostId,
                roleId,
                apiId,
                apiVersion,
                endpoint
        );
        if (result.isFailure()) {
            return NioUtils.toByteBuffer(
                    getStatus(exchange, OBJECT_NOT_FOUND, "role row filter", hostId)
            );
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
