
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get dropdown id and label for role
*/
@ServiceHandler(id="lightapi.net/role/getRoleLabel/0.1.0")
public class GetRoleLabel implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRoleLabel.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = {}", input);
        Map<String, Object> map = (Map<String, Object>)input;
        String hostId = (String)map.get("hostId");
        if(logger.isTraceEnabled())
            logger.trace("hostId = {}", hostId);
        Result<String> result = dbProvider.queryRoleLabel(hostId);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "roleId", hostId));
        } else {
            String roleIds = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("roleIds = {}", roleIds);
            return NioUtils.toByteBuffer(roleIds);
        }
    }
}
