
package net.lightapi.portal.role.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Get a role by host id. This endpoint is used by the API to load the roles in the role admin page.
*/
@ServiceHandler(id="lightapi.net/role/getRole/0.1.0")
public class GetRole implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRole.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        if(logger.isTraceEnabled()) logger.trace("input = " + input);
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String hostId = (String)map.get("hostId");
        String roleId = (String)map.get("roleId");
        if(StringUtils.isEmpty(roleId)) roleId = null;
        String roleDesc = (String)map.get("roleDesc");
        if(StringUtils.isEmpty(roleDesc)) roleDesc = null;
        if(logger.isTraceEnabled())
            logger.trace("offset = {} limit = {} hostId = {} roleId = {} roleDesc = {}", offset, limit, hostId, roleId, roleDesc);
        Result<String> result = dbProvider.queryRole(offset, limit, hostId, roleId, roleDesc);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "role", hostId));
        } else {
            String roles = result.getResult();
            if(logger.isTraceEnabled()) logger.trace("roles = {}", roles);
            return NioUtils.toByteBuffer(roles);
        }
    }
}
