
package net.lightapi.portal.role.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Delete a role user from the host.
*/
@ServiceHandler(id="lightapi.net/role/deleteRoleUser/0.1.0")
public class DeleteRoleUser extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRoleUser.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ROLE_USER_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
