
package net.lightapi.portal.role.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Delete a role permission for the host.
*/
@ServiceHandler(id="lightapi.net/role/deleteRolePermission/0.1.0")
public class DeleteRolePermission extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteRolePermission.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ROLE_PERMISSION_DELETED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
