
package net.lightapi.portal.role.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Create a new role user for the host.
*/
@ServiceHandler(id="lightapi.net/role/createRoleUser/0.1.0")
public class CreateRoleUser extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRoleUser.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ROLE_USER_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
