
package net.lightapi.portal.role.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Create a new role row filter for the host.
*/
@ServiceHandler(id="lightapi.net/role/createRoleRowFilter/0.1.0")
public class CreateRoleRowFilter extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRoleRowFilter.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ROLE_ROW_FILTER_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
