
package net.lightapi.portal.role.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This is the endpoint to create a new role from the role admin page.
*/
@ServiceHandler(id="lightapi.net/role/createRole/0.1.0")
public class CreateRole extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateRole.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.ROLE_CREATED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
