
package net.lightapi.portal.ref.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ref table with pagination and filter
*/
@ServiceHandler(id="lightapi.net/ref/getRefTable/0.1.0")
public class GetRefTable implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetRefTable.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");

        String tableId = (String)map.get("tableId");
        if(StringUtils.isBlank(tableId)) tableId = null;
        String hostId = (String)map.get("hostId");
        if(StringUtils.isBlank(hostId)) hostId = null;
        String tableName = (String)map.get("tableName");
        if(StringUtils.isBlank(tableName)) tableName = null;
        String tableDesc = (String)map.get("tableDesc");
        if(StringUtils.isBlank(tableDesc)) tableDesc = null;
        Boolean active = (Boolean)map.get("active");
        Boolean editable = (Boolean)map.get("editable");

        Result<String> result = dbProvider.getRefTable(offset, limit, hostId, tableId, tableName,
                tableDesc, active, editable);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref table", "offset limit"));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
