
package net.lightapi.portal.ref.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ref relation type with pagination and filter
*/
@ServiceHandler(id="lightapi.net/ref/getRefRelationType/0.1.0")
public class GetRefRelationType implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetRefRelationType.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");

        String relationId = (String)map.get("relationId");
        if(StringUtils.isBlank(relationId)) relationId = null;
        String relationName = (String)map.get("relationName");
        if(StringUtils.isBlank(relationName)) relationName = null;
        String relationDesc = (String)map.get("relationDesc");
        if(StringUtils.isBlank(relationDesc)) relationDesc = null;

        Result<String> result = dbProvider.getRefRelationType(offset, limit, relationId, relationName, relationDesc);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref relation type", "offset limit"));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
