
package net.lightapi.portal.ref.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ref relation with pagination and filter
*/
@ServiceHandler(id="lightapi.net/ref/getRefRelation/0.1.0")
public class GetRefRelation implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetRefRelation.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");

        String relationId = (String)map.get("relationId");
        if(StringUtils.isBlank(relationId)) relationId = null;
        String relationName = (String)map.get("relationName");
        if(StringUtils.isBlank(relationName)) relationName = null;
        String valueIdFrom = (String)map.get("valueIdFrom");
        if(StringUtils.isBlank(valueIdFrom)) valueIdFrom = null;
        String valueCodeFrom = (String)map.get("valueCodeFrom");
        if(StringUtils.isBlank(valueCodeFrom)) valueCodeFrom = null;
        String valueIdTo = (String)map.get("valueIdTo");
        if(StringUtils.isBlank(valueIdTo)) valueIdTo = null;
        String valueCodeTo = (String)map.get("valueCodeTo");
        if(StringUtils.isBlank(valueCodeTo)) valueCodeTo = null;
        Boolean active = (Boolean)map.get("active");

        Result<String> result = dbProvider.getRefRelation(offset, limit, relationId, relationName, valueIdFrom, valueCodeFrom, valueIdTo, valueCodeTo, active);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref relation", "offset limit"));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
