
package net.lightapi.portal.ref.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ref value with pagination an filter
*/
@ServiceHandler(id="lightapi.net/ref/getRefValue/0.1.0")
public class GetRefValue implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetRefValue.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");

        String valueId = (String)map.get("valueId");
        if(StringUtils.isBlank(valueId)) valueId = null;
        String tableId = (String)map.get("tableId");
        if(StringUtils.isBlank(tableId)) tableId = null;
        String valueCode = (String)map.get("valueCode");
        if(StringUtils.isBlank(valueCode)) valueCode = null;
        String valueDesc = (String)map.get("valueDesc");
        if(StringUtils.isBlank(valueDesc)) valueDesc = null;
        Integer displayOrder = (Integer)map.get("displayOrder");
        Boolean active = (Boolean)map.get("active");

        Result<String> result = dbProvider.getRefValue(offset, limit, valueId, tableId, valueCode,
                valueDesc, displayOrder, active);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref value", "offset limit"));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
