
package net.lightapi.portal.ref.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import java.nio.ByteBuffer;
import java.util.Map;

import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * get ref locale with pagination an filter
*/
@ServiceHandler(id="lightapi.net/ref/getRefLocale/0.1.0")
public class GetRefLocale implements HybridHandler {
    public static final Logger logger = LoggerFactory.getLogger(GetRefLocale.class);
    public static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider) SingletonServiceFactory.getBean(DbProvider.class);

    @Override
    public ByteBuffer handle(HttpServerExchange exchange, Object input)  {
        Map<String, Object> map = (Map<String, Object>)input;
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");

        String valueId = (String)map.get("valueId");
        if(StringUtils.isBlank(valueId)) valueId = null;
        String valueCode = (String)map.get("valueCode");
        if(StringUtils.isBlank(valueCode)) valueCode = null;
        String valueDesc = (String)map.get("valueDesc");
        if(StringUtils.isBlank(valueDesc)) valueDesc = null;
        String language = (String)map.get("language");
        if(StringUtils.isBlank(language)) language = null;
        String valueLabel = (String)map.get("valueLabel");
        if(StringUtils.isBlank(valueLabel)) valueLabel = null;

        Result<String> result = dbProvider.getRefLocale(offset, limit, valueId, valueCode, valueDesc, language, valueLabel);
        if(result.isFailure()) {
            return NioUtils.toByteBuffer(getStatus(exchange, OBJECT_NOT_FOUND, "ref locale", "offset limit"));
        } else {
            return NioUtils.toByteBuffer(result.getResult());
        }
    }
}
