
package net.lightapi.portal.product.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * delete a product version environment
*/
@ServiceHandler(id="lightapi.net/product/deleteProductVersionEnvironment/0.1.0")
public class DeleteProductVersionEnvironment extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProductVersionEnvironment.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.PRODUCT_VERSION_ENVIRONMENT_DELETED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PRODUCT_VERSION;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the productVersionId in the data section.
        return (String) map.get("productVersionId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
