
package net.lightapi.portal.product.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * create a new product version from the portal-view UI product menu.
 */
@ServiceHandler(id="lightapi.net/product/createProductVersion/0.1.0")
public class CreateProductVersion extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateProductVersion.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.PRODUCT_CREATED_EVENT;
    }

    @Override
    public String getCloudEventAggregateType() {
        return PortalConstants.AGGREGATE_PRODUCT_VERSION;
    }

    @Override
    public String getCloudEventAggregateId(Map<String, Object> map) {
        // the aggregate id is the productVersionId in the data section.
        return (String) map.get("productVersionId");
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }


    @Override
    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        map.put("productVersionId", UuidUtil.getUUID().toString());
        return Success.of(map);
    }
}
