/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/getRefreshTokenDetail/0.1.0")
public class GetRefreshTokenDetail
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetRefreshTokenDetail.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String refreshToken = (String)map.get("refreshToken");
        if (logger.isTraceEnabled()) {
            logger.trace("refreshToken = {}", (Object)refreshToken);
        }
        if ((result = dbProvider.queryRefreshToken(refreshToken)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"refresh token", refreshToken}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

