/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/getProvider/0.1.0")
public class GetProvider
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetProvider.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String updateUser;
        String jwk;
        String deliveryOwner;
        String operationOwner;
        String providerDesc;
        String providerName;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String providerId = (String)map.get("providerId");
        if (StringUtils.isBlank((CharSequence)providerId)) {
            providerId = null;
        }
        if (StringUtils.isBlank((CharSequence)(providerName = (String)map.get("providerName")))) {
            providerName = null;
        }
        if (StringUtils.isBlank((CharSequence)(providerDesc = (String)map.get("providerDesc")))) {
            providerDesc = null;
        }
        if (StringUtils.isBlank((CharSequence)(operationOwner = (String)map.get("operationOwner")))) {
            operationOwner = null;
        }
        if (StringUtils.isBlank((CharSequence)(deliveryOwner = (String)map.get("deliveryOwner")))) {
            deliveryOwner = null;
        }
        if (StringUtils.isBlank((CharSequence)(jwk = (String)map.get("jwk")))) {
            jwk = null;
        }
        if (StringUtils.isBlank((CharSequence)(updateUser = (String)map.get("updateUser")))) {
            updateUser = null;
        }
        Timestamp updateTs = null;
        String s = (String)map.get("updateTs");
        if (!StringUtils.isBlank((CharSequence)s)) {
            updateTs = Timestamp.valueOf(s);
        }
        if ((result = dbProvider.queryProvider(offset, limit, hostId, providerId, providerName, providerDesc, operationOwner, deliveryOwner, jwk, updateUser, updateTs)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"provider", hostId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

