/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.query.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/getClientById/0.1.0")
public class GetClientById
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetClientById.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    private static final String PERMISSION_DENIED = "ERR11620";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Map map;
        String clientId;
        Result result;
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        if ((result = dbProvider.queryClientByClientId(clientId = (String)(map = (Map)input).get("clientId"))).isSuccess()) {
            Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            Map clientMap = JsonMapper.string2Map((String)((String)result.getResult()));
            if (auditInfo != null) {
                String userId = (String)auditInfo.get("user_id");
                if (userId != null) {
                    clientMap.remove("clientSecret");
                    return NioUtils.toByteBuffer((String)JsonMapper.toJson((Object)clientMap));
                }
                return NioUtils.toByteBuffer((String)JsonMapper.toJson((Object)clientMap));
            }
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, PERMISSION_DENIED, new Object[]{"Missing token"}));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"application with clientId ", clientId}));
    }
}

