/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/getClient/0.1.0")
public class GetClient
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetClient.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String deRefClientId;
        String authenticateClass;
        String redirectUri;
        String customClaim;
        String clientScope;
        String clientProfile;
        String clientType;
        String clientName;
        String clientId;
        String apiId;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String appId = (String)map.get("appId");
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = null;
        }
        if (StringUtils.isBlank((CharSequence)(apiId = (String)map.get("apiId")))) {
            apiId = null;
        }
        if (StringUtils.isBlank((CharSequence)(clientId = (String)map.get("clientId")))) {
            clientId = null;
        }
        if (StringUtils.isBlank((CharSequence)(clientName = (String)map.get("clientName")))) {
            clientName = null;
        }
        if (StringUtils.isBlank((CharSequence)(clientType = (String)map.get("clientType")))) {
            clientType = null;
        }
        if (StringUtils.isBlank((CharSequence)(clientProfile = (String)map.get("clientProfile")))) {
            clientProfile = null;
        }
        if (StringUtils.isBlank((CharSequence)(clientScope = (String)map.get("clientScope")))) {
            clientScope = null;
        }
        if (StringUtils.isBlank((CharSequence)(customClaim = (String)map.get("customClaim")))) {
            customClaim = null;
        }
        if (StringUtils.isBlank((CharSequence)(redirectUri = (String)map.get("redirectUri")))) {
            redirectUri = null;
        }
        if (StringUtils.isBlank((CharSequence)(authenticateClass = (String)map.get("authenticateClass")))) {
            authenticateClass = null;
        }
        if (StringUtils.isBlank((CharSequence)(deRefClientId = (String)map.get("deRefClientId")))) {
            deRefClientId = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("offset = {} limit = {} hostId = {} appId = {} apiId = {} clientId = {} clientName = {} clientType = {} clientProfile = {} clientScope = {} customClaim = {} redirectUri = {} authenticateClass = {} deRefClientId = {}", new Object[]{offset, limit, hostId, appId, apiId, clientId, clientName, clientType, clientProfile, clientScope, customClaim, redirectUri, authenticateClass, deRefClientId});
        }
        if ((result = dbProvider.queryClient(offset, limit, hostId, appId, apiId, clientId, clientName, clientType, clientProfile, clientScope, customClaim, redirectUri, authenticateClass, deRefClientId)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"client", "hostId:" + hostId + " appId:" + appId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

