/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.oauth.query.handler;

import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.NioUtils;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Map;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/oauth/getAuthCode/0.1.0")
public class GetAuthCode
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(GetAuthCode.class);
    private static final String OBJECT_NOT_FOUND = "ERR11637";
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        Result result;
        String updateUser;
        String challengeMethod;
        String codeChallenge;
        String remember;
        String scope;
        String redirectUri;
        String attributes;
        String positions;
        String groups;
        String roles;
        String email;
        String userType;
        String entityId;
        String userId;
        if (logger.isTraceEnabled()) {
            logger.trace("input = {}", input);
        }
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        int offset = (Integer)map.get("offset");
        int limit = (Integer)map.get("limit");
        String authCode = (String)map.get("authCode");
        if (StringUtils.isBlank((CharSequence)authCode)) {
            authCode = null;
        }
        if (StringUtils.isBlank((CharSequence)(userId = (String)map.get("userId")))) {
            userId = null;
        }
        if (StringUtils.isBlank((CharSequence)(entityId = (String)map.get("entityId")))) {
            entityId = null;
        }
        if (StringUtils.isBlank((CharSequence)(userType = (String)map.get("userType")))) {
            userType = null;
        }
        if (StringUtils.isBlank((CharSequence)(email = (String)map.get("email")))) {
            email = null;
        }
        if (StringUtils.isBlank((CharSequence)(roles = (String)map.get("roles")))) {
            roles = null;
        }
        if (StringUtils.isBlank((CharSequence)(groups = (String)map.get("groups")))) {
            groups = null;
        }
        if (StringUtils.isBlank((CharSequence)(positions = (String)map.get("positions")))) {
            positions = null;
        }
        if (StringUtils.isBlank((CharSequence)(attributes = (String)map.get("attributes")))) {
            attributes = null;
        }
        if (StringUtils.isBlank((CharSequence)(redirectUri = (String)map.get("redirectUri")))) {
            redirectUri = null;
        }
        if (StringUtils.isBlank((CharSequence)(scope = (String)map.get("scope")))) {
            scope = null;
        }
        if (StringUtils.isBlank((CharSequence)(remember = (String)map.get("remember")))) {
            remember = null;
        }
        if (StringUtils.isBlank((CharSequence)(codeChallenge = (String)map.get("codeChallenge")))) {
            codeChallenge = null;
        }
        if (StringUtils.isBlank((CharSequence)(challengeMethod = (String)map.get("challengeMethod")))) {
            challengeMethod = null;
        }
        if (StringUtils.isBlank((CharSequence)(updateUser = (String)map.get("updateUser")))) {
            updateUser = null;
        }
        if (StringUtils.isBlank((CharSequence)updateUser)) {
            updateUser = null;
        }
        Timestamp updateTs = null;
        String s = (String)map.get("updateTs");
        if (!StringUtils.isBlank((CharSequence)s)) {
            updateTs = Timestamp.valueOf(s);
        }
        if ((result = dbProvider.listAuthCode(offset, limit, authCode, hostId, userId, entityId, userType, email, roles, groups, positions, attributes, redirectUri, scope, remember, codeChallenge, challengeMethod, updateUser, updateTs)).isFailure()) {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, OBJECT_NOT_FOUND, new Object[]{"auth code", hostId}));
        }
        return NioUtils.toByteBuffer((String)((String)result.getResult()));
    }
}

